<?php

namespace MessageBird\Objects\Conversation;

use MessageBird\Objects\Base;

/**
 * Channels represent a platform that messages can be sent and received on. You
 * can configure your channels via the MessageBird dashboard. A conversation
 * can take place over multiple channels simultaneously.
 */
class Channel extends Base
{
    const STATUS_ACTIVE = 'active';
    const STATUS_ACTIVATING = 'activating';
    const STATUS_ACTIVATION_CODE_REQUIRED = 'activation_code_required';
    const STATUS_ACTIVATION_REQUIRED = 'activation_required';
    const STATUS_DELETED = 'deleted';
    const STATUS_INACTIVE = 'inactive';
    const STATUS_PENDING = 'pending';

    /**
     * The unique ID generated by the MessageBird platform that identifies this
     * channel.
     *
     * @var string
     */
    public $id;

    /**
     * The name of this channel (configured through the MessageBird dashboard).
     *
     * @var string
     */
    public $name;

    /**
     * A unique identifier for the platform that is used by this channel, for
     * example: sms, telegram or messenger.
     *
     * @var string
     */
    public $platformId;

    /**
     * The status of this channel. Only active channels can be used for
     * messaging. Can be one of inactive, active, pending, activation_required,
     * activation_code_required, activating, and deleted.
     *
     * @var string
     */
    public $status;

    /**
     * The datetime when the message was created (in RFC3339 format).
     *
     * @var string
     */
    public $createdDatetime;

    /**
     * The datetime when the message was updated (in RFC3339 format).
     *
     * @var string
     */
    public $updatedDatetime;
}
