@extends('layouts.customer')

@section('title') {{trans('customer.devices')}} @endsection

@section('extra-css')
    <link rel="stylesheet" href="{{asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')}}">
    <link rel="stylesheet" href="{{asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css')}}">
    <style>
        .modal-qr-code {
            height: 200px;
            width: 220px;
            margin: 0 auto;
        }

        .modal-qr-code img {
            width: 100%;
            height: 100%;
        }


        #qrcode {
            width: 100%;
            height: 100%;
            margin: 0 auto;
            text-align: center;
        }

        #qrcode a {
            font-size: 0.8em;
        }

        .qr-url, .qr-size {
            padding: 0.5em;
            border: 1px solid #ddd;
            border-radius: 2px;
            -webkit-box-sizing: border-box;
            -moz-box-sizing: border-box;
            box-sizing: border-box;
        }

        canvas {
            height: 100%;
            width: 100%;
        }
    </style>
@endsection

@section('content')
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h2 class="card-title">@lang('customer.list')
                            <span class="ml-2 what-font-size icon-position" data-toggle="tooltip" data-placement="right" title="{{trans('customer.device_description')}}">
                                <i class="fa fa-question-circle"></i>
                            </span>
                        </h2>
                        <div class="float-right">
                            @can('device_add')
                            <button type="button" class="btn btn-primary generate-qr-code disable" disabled data-toggle="modal"
                                    data-target="#deviceCreate">
                                {{trans('customer.add_new_device')}}
                            </button>
                            @endcanany
                        </div>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body">
                        <table id="deviceTable" class="table table-striped table-bordered dt-responsive nowrap">
                            <thead>
                            <tr>
                                <th>{{trans('customer.device_name')}}</th>
                                <th>{{trans('customer.total_sent_message')}}</th>
                                <th>{{trans('customer.status')}}</th>
                                <th>{{trans('customer.action')}}</th>
                            </tr>
                            </thead>

                        </table>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
            <!-- /.col -->
        </div>
        <!-- /.row -->
    </section>
    <!-- /.content -->

    <div class="modal fade" id="deviceCreate" tabindex="-1" role="dialog"
    aria-labelledby="deviceCreateTitle" aria-hidden="true">
   <div class="modal-dialog modal-dialog-centered" role="document">
       <div class="modal-content">
           <div class="modal-header">
               <h5 class="modal-title" id="deviceCreateLongTitle">{{trans('customer.add_new_device')}}</h5>
               <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                   <span class="close-icon" aria-hidden="true">&times;</span>
               </button>
           </div>
           <div class="modal-body">
               <div class="form-group" id="create_device_section">
                   <label for="device_name">{{trans('customer.device_name')}}</label>
                   <input type="text" class="form-control" id="device_name">
               </div>

               <div id="instructions" class="d-none">
                   <div class="form-group">
                       <p>Just follow the below steps to connect your WhatsApp.</p>
                       <ul class="device-text">
                           <li><b>Step 1 :</b> Open WhatsApp on your phone.</li>
                           <li><b>Step 2 :</b> <span dir="ltr" class="_11JPr">Tap <strong><span dir="ltr"
                                           class="_11JPr">Menu <span class="l7jjieqr fewfhwl7"><svg height="24px"
                                                   viewBox="0 0 24 24" width="24px">
                                                   <rect fill="#f2f2f2" height="24" rx="3" width="24">
                                                   </rect>
                                                   <path
                                                       d="m12 15.5c.825 0 1.5.675 1.5 1.5s-.675 1.5-1.5 1.5-1.5-.675-1.5-1.5.675-1.5 1.5-1.5zm0-2c-.825 0-1.5-.675-1.5-1.5s.675-1.5 1.5-1.5 1.5.675 1.5 1.5-.675 1.5-1.5 1.5zm0-5c-.825 0-1.5-.675-1.5-1.5s.675-1.5 1.5-1.5 1.5.675 1.5 1.5-.675 1.5-1.5 1.5z"
                                                       fill="#818b90"></path>
                                               </svg></span></span></strong> or <strong><span dir="ltr"
                                           class="_11JPr">Settings <span class="l7jjieqr fewfhwl7"><svg width="24"
                                                   height="24" viewBox="0 0 24 24">
                                                   <rect fill="#F2F2F2" width="24" height="24" rx="3">
                                                   </rect>
                                                   <path
                                                       d="M12 18.69c-1.08 0-2.1-.25-2.99-.71L11.43 14c.24.06.4.08.56.08.92 0 1.67-.59 1.99-1.59h4.62c-.26 3.49-3.05 6.2-6.6 6.2zm-1.04-6.67c0-.57.48-1.02 1.03-1.02.57 0 1.05.45 1.05 1.02 0 .57-.47 1.03-1.05 1.03-.54.01-1.03-.46-1.03-1.03zM5.4 12c0-2.29 1.08-4.28 2.78-5.49l2.39 4.08c-.42.42-.64.91-.64 1.44 0 .52.21 1 .65 1.44l-2.44 4C6.47 16.26 5.4 14.27 5.4 12zm8.57-.49c-.33-.97-1.08-1.54-1.99-1.54-.16 0-.32.02-.57.08L9.04 5.99c.89-.44 1.89-.69 2.96-.69 3.56 0 6.36 2.72 6.59 6.21h-4.62zM12 19.8c.22 0 .42-.02.65-.04l.44.84c.08.18.25.27.47.24.21-.03.33-.17.36-.38l.14-.93c.41-.11.82-.27 1.21-.44l.69.61c.15.15.33.17.54.07.17-.1.24-.27.2-.48l-.2-.92c.35-.24.69-.52.99-.82l.86.36c.2.08.37.05.53-.14.14-.15.15-.34.03-.52l-.5-.8c.25-.35.45-.73.63-1.12l.95.05c.21.01.37-.09.44-.29.07-.2.01-.38-.16-.51l-.73-.58c.1-.4.19-.83.22-1.27l.89-.28c.2-.07.31-.22.31-.43s-.11-.35-.31-.42l-.89-.28c-.03-.44-.12-.86-.22-1.27l.73-.59c.16-.12.22-.29.16-.5-.07-.2-.23-.31-.44-.29l-.95.04c-.18-.4-.39-.77-.63-1.12l.5-.8c.12-.17.1-.36-.03-.51-.16-.18-.33-.22-.53-.14l-.86.35c-.31-.3-.65-.58-.99-.82l.2-.91c.03-.22-.03-.4-.2-.49-.18-.1-.34-.09-.48.01l-.74.66c-.39-.18-.8-.32-1.21-.43l-.14-.93a.426.426 0 00-.36-.39c-.22-.03-.39.05-.47.22l-.44.84-.43-.02h-.22c-.22 0-.42.01-.65.03l-.44-.84c-.08-.17-.25-.25-.48-.22-.2.03-.33.17-.36.39l-.13.88c-.42.12-.83.26-1.22.44l-.69-.61c-.15-.15-.33-.17-.53-.06-.18.09-.24.26-.2.49l.2.91c-.36.24-.7.52-1 .82l-.86-.35c-.19-.09-.37-.05-.52.13-.14.15-.16.34-.04.51l.5.8c-.25.35-.45.72-.64 1.12l-.94-.04c-.21-.01-.37.1-.44.3-.07.2-.02.38.16.5l.73.59c-.1.41-.19.83-.22 1.27l-.89.29c-.21.07-.31.21-.31.42 0 .22.1.36.31.43l.89.28c.03.44.1.87.22 1.27l-.73.58c-.17.12-.22.31-.16.51.07.2.23.31.44.29l.94-.05c.18.39.39.77.63 1.12l-.5.8c-.12.18-.1.37.04.52.16.18.33.22.52.14l.86-.36c.3.31.64.58.99.82l-.2.92c-.04.22.03.39.2.49.2.1.38.08.54-.07l.69-.61c.39.17.8.33 1.21.44l.13.93c.03.21.16.35.37.39.22.03.39-.06.47-.24l.44-.84c.23.02.44.04.66.04z"
                                                       fill="#818b90"></path>
                                               </svg></span></span></strong> and select <strong>Linked
                                       Devices</strong></span></li>
                           <li><b>Step 3 :</b><span>Tap on <strong>Link a device</strong></span></li>
                           <li><b>Step 4 :</b> <span>Point your phone to this screen to capture the QR code</span></li>
                       </ul>
                   </div>

                   <div class="modal-qr-code">
                       <canvas id="qrcode"></canvas>
                   </div>
               </div>

           </div>
           <div class="modal-footer border-0">
               <button type="button" class="btn btn-primary text-front-normal" id="deviceCreateBtn">Create</button>
               <button type="button" class="btn btn-secondary text-front-normal d-none" id="modalCloseBtn" data-dismiss="modal">Close</button>
           </div>
       </div>
   </div>
</div>
    <input type="hidden" id="add_type" value="{{request()->get('type')}}">
@endsection

@section('extra-scripts')
    <script src="{{asset('plugins/datatables/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('plugins/datatables-bs4/js/dataTables.bootstrap4.min.js')}}"></script>
    <script src="{{asset('plugins/datatables-responsive/js/dataTables.responsive.min.js')}}"></script>
    <script src="{{asset('plugins/datatables-responsive/js/responsive.bootstrap4.min.js')}}"></script>
    <script src="{{asset('js/readmore.min.js')}}"></script>
    {{--    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.qrcode/1.0/jquery.qrcode.min.js" ></script>--}}
    <script src="https://cdnjs.cloudflare.com/ajax/libs/qrious/4.0.2/qrious.min.js"></script>
    <script src="https://cdn.socket.io/4.7.2/socket.io.min.js" integrity="sha384-mZLF4UVrpi/QTWPA7BjNPEnkIfRFn4ZEO3Qt/HFklTJBj/gBOV8G3HcKn4NfQblz" crossorigin="anonymous"></script>

    <script>
        "use strict";
        const socket = io("{{config('pico.wa_server_host')}}");
        socket.on("connect", () => {
            $('.generate-qr-code').removeAttr('disabled').removeClass('disable');
            const add_type = $('#add_type').val();
            if (add_type == 'addwadevice'){
                $('.generate-qr-code').trigger('click');
            }
        });
        socket.on("qrcode", (res) => {
            if(!res.code){
                notify('danger','Invalid qr code')
                retrn;
            }
            const code=res.code;
            new QRious({element: document.getElementById("qrcode"), value: code, size: 200});
        });

        socket.on('scanned',(resp)=>{
            $.ajax({
                method:'post',
                url:"{{route('customer.wadevice.status')}}",
                data:{id:resp.id,status:'active',_token:"{{csrf_token()}}"},
                success:(res)=>{
                    console.log(res);
                    $('#deviceCreate').modal('hide');
                    setTimeout(() => {
                        deviceTable.ajax.reload();
                    }, 2000);

                }
            });
        })
    </script>
    <script>
        const deviceTable=$('#deviceTable').DataTable({
            processing: true,
            serverSide: true,
            responsive: true,
            ajax: '{{route('customer.get.all.wadevice')}}',
            columns: [
                {"data": "name"},
                {"data": "total_sent_message"},
                {"data": "status"},
                {"data": "action"},
            ],
        });

        $('#deviceCreateBtn').on('click', function (e) {
            e.preventDefault();
            $('#qrcode').empty();
            const name=$("#device_name").val();
            $.ajax({
                method:'post',
                url:"{{route('customer.wadevice.store')}}",
                data:{name:name,type:'whatsapp',_token:"{{csrf_token()}}"},
                success:(res)=>{
                    $('#create_device_section').addClass('d-none');
                    $('#instructions').removeClass('d-none');
                    deviceTable.ajax.reload();
                    socket.emit('scan',{id:res.data.device_unique_id})
                    $(this).addClass('d-none');
                    $('#modalCloseBtn').removeClass('d-none');
                },
                error:(err)=>{
                    if(err.responseJSON && err.responseJSON){
                        const messages=err.responseJSON.message;
                        console.log(typeof messages);
                        let alertMessage = "";
                        if (typeof messages == "object") {
                            for (const key in messages) {
                            alertMessage += messages[key][0] + "\n\r";
                            }
                        } else {
                            alertMessage = messages;
                        }
                        notify('danger',alertMessage)
                    }
                }
            })
         });

    </script>
@endsection

