@extends('layouts.customer')

@section('title',__('customer.ussd_create'))

@section('extra-css')
    <link rel="stylesheet" href="{{asset('plugins/select2/css/select2.min.css')}}">
@endsection

@section('content')
    <section class="content">
        <div class="row">
            <div class="col-12 mx-auto col-sm-10 mt-3">
                <div class="card">
                    <div class="card-header">
                        <h2 class="card-title">@lang('customer.ussd_create')</h2>
                        <a class="btn btn-info float-right" href="{{route('customer.ussd.index')}}">@lang('customer.back')</a>
                    </div>
                    <form method="post" role="form" id="ussdForm" action="{{route('customer.ussd.store')}}" enctype="multipart/form-data">
                        @csrf
                        <div class="card-body">
                            @include('customer.ussd.form')
                        </div>
                        <div class="card-footer">
                            <button type="submit" class="btn btn-primary">@lang('customer.sent')</button>
                        </div>
                    </form>
                </div>
            </div>
            <!-- /.card -->
        </div>
        <!-- /.col -->
        </div>
        <!-- /.row -->
    </section>
    <!-- /.content -->
@endsection

@section('extra-scripts')
    <script src="{{asset('plugins/jquery-validation/jquery.validate.min.js')}}"></script>
    <script src="{{asset('plugins/select2/js/select2.full.min.js')}}"></script>
    <script !src="">
        "use strict";

        $('#ussdForm').validate({
            rules: {
                request: {
                    required: true,
                },
                device_id: {
                    required: true,
                },
                subscriber_id: {
                    required: true,
                }
            },
            messages: {
                request:"Request is required",
                device_id:"Device is required",
                subscriber_id:"Sim is required",
            },
            errorElement: 'span',
            errorPlacement: function (error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight: function (element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function (element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            }
        });

        $('#device_id').on('change', function (e) {
            e.preventDefault();
            $('#sim_id').html('');
            let simInfo = $('option:selected', this).attr('data-sim-info');

            if (simInfo) {
                simInfo = JSON.parse(simInfo);
                if (simInfo && typeof simInfo == 'object') {
                    let options = '';
                    for (let sim of simInfo) {
                        let singleSimInfo = sim.split(':');
                        options += `<option value="${singleSimInfo[1]}">${singleSimInfo[2]} (SIM ${parseInt(singleSimInfo[0])+1})</option>`
                    }
                    $('#sim_id').html(options);

                }
            }
        });

        $('#device_id').trigger('change');
    </script>
@endsection

