@extends('layouts.customer')

@section('title','Compose | SmsBox')

@section('extra-css')
<link rel="stylesheet" href="{{asset('plugins/select2/css/select2.min.css')}}">
<link rel="stylesheet" href="{{asset('plugins/daterangepicker/daterangepicker.css')}}">
<link rel="stylesheet" href="{{asset('plugins/icheck-bootstrap/icheck-bootstrap.min.css')}}">
<link rel="stylesheet" href="{{asset('css/msg_overview.css')}}">
<style>
    #select2-toNumbers-results,
    #select2-fromNumber-results {
        overflow-y: auto;
        max-height: 200px;
    }

    .iphone {
        width: 300px;
        height: 609px;
        background-size: 100% 100%;
        margin: 0 auto;
        position: relative;
    }

    .user-chat-profile {
        font-size: 30px;
        padding: 20px 5px;
    }

    .chat-box-text-sec {
        color: #fff;
        margin-left: auto;
        background-color: #00a9de;
    }

    .chat-message-content {
        font-size: 18px;
        padding: 10px 20px;
        border-radius: 25px;
        color: #fff;
        background-color: #00a9de;
        max-width: 600px;
        width: -webkit-fit-content;
        width: -moz-fit-content;
        width: fit-content;
        position: relative;
        margin: 15px 10px;
        word-break: break-all;
        direction: ltr;
    }

    .chat-curve-reply:after {
        content: "";
        width: 20px;
        height: 12px;
        display: block;
        background-image: url("https://stageviewcincyshakes.firebaseapp.com/icon-gray-message.e6296433d6a72d473ed4.png");
        background-repeat: no-repeat;
        background-position: center;
        background-size: contain;
        position: absolute;
        bottom: -2px;
        left: -5px;
    }

    .chat-message-content:after {
        width: 19px;
        height: 13px;
        left: inherit;
        right: -5px;
        background-image: url("https://stageviewcincyshakes.firebaseapp.com/icon-blue-message.2be55af0d98ee2864e29.png");
    }

    .chat-application-sec {
        display: flex;
        justify-content: flex-end;
        align-items: flex-end;
        overflow-y: hidden;
    }

    .chat-date-time {
        font-size: 8px;
        margin: 5px 0px;
    }

    .chat-text-area {
        font-size: 13px;
    }

    .card-head-title {
        font-weight: 600;
        font-family: "Montserrat", sans-serif !important;
        font-size: 17px;
    }

    .label-head {
        font-size: 1rem !important;
        font-weight: 600 !important;
    }
</style>

@endsection

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>{{trans('customer.quick_send')}}</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a
                            href="{{route('customer.smsbox.overview')}}">{{trans('customer.smsbox')}}</a></li>
                    <li class="breadcrumb-item active">{{trans('customer.quick_send')}}</li>
                </ol>
            </div>
        </div>
    </div><!-- /.container-fluid -->
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <!-- /.col -->
        <div class="col-lg-8 col-md-7 mx-auto">
            <div class="card card-primary card-outline">
                <form id="compose_form" action="{{route('customer.smsbox.compose.sent')}}" method="post"
                    enctype="multipart/form-data">
                    @csrf
                    <div class="card-header">
                        <h3 class="card-title card-head-title">{{trans('customer.compose_new_message')}}</h3>
                    </div>
                    <input type="hidden" name="device_type" value="device" class="device_type">
                    <!-- /.card-header -->
                    <div class="card-body">
                        <ul class="nav nav-pills mb-3 mt-5" id="pills-tab" role="tablist">
                            <li class="nav-item contact-data mr-2">
                                <a class="nav-link custom nav-link-hover active activeDevice" data-type="device" id="pills-home-tab" data-toggle="pill"
                                    href="#pills-home" role="tab" aria-controls="pills-home"
                                    aria-selected="true">@lang('customer.devices')</a>
                            </li>
                            <li class="nav-item contact-data d-none">
                                <a class="nav-link custom nav-link-hover activeDevice" data-type="whatsapp" id="pills-profile-tab" data-toggle="pill"
                                    href="#pills-profile" role="tab" aria-controls="pills-profile"
                                    aria-selected="false">@lang('customer.wa_devices')</a>
                            </li>
                        </ul>
                        <div class="tab-content" id="myTabContent">
                            <div class="tab-pane fade show active" id="pills-home" role="tabpanel"
                                aria-labelledby="pills-home-tab">
                                <div class="form-group">
                                    <label for="device_id" class="label-head">Select Device</label>
                                    <select name="device_id" class="form-control" id="device_id">
                                        <option value="">Choose a device</option>
                                        @foreach($devices as $device)
                                        <option data-sim-info="{{$device->sim_info}}" device_name="{{$device->name}}"
                                            value="{{$device->id}}">{{$device->name}} ({{$device->model}})
                                        </option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="sim_id" class="label-head">Select SIM</label>
                                    <select name="subscriber_id" class="form-control select2" id="sim_id">
                                    </select>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="pills-profile" role="tabpanel"
                                aria-labelledby="pills-profile-tab">
                                <div class="form-group">
                                    <label for="wadevice_id" class="label-head">Select Device</label>
                                    <select name="wadevice_id" class="form-control select2" id="wadevice_id">
                                        <option value="">Choose a device</option>
                                        @foreach($wadevices as $device)
                                        <option data-sim-info="{{$device->sim_info}}" device_name="{{$device->name}}"
                                            value="{{$device->id}}">{{$device->name}} ({{$device->model}})
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>


                        {{-- <div class="form-group">
                            <label for="device_id" class="label-head">Select Device</label>
                            <select name="device_id" class="form-control select2" id="device_id">
                                <option value="">Choose a device</option>
                                @foreach($devices as $device)
                                <option data-sim-info="{{$device->sim_info}}" device_name="{{$device->name}}"
                                    value="{{$device->id}}">{{$device->name}} ({{$device->model}})
                                </option>
                                @endforeach
                            </select>
                        </div> --}}



                        <div id="pre_draft">
                            @isset($draft)
                            <input type='hidden' id='draft_id' name='draft_id' value='{{$draft->id}}' />
                            @endisset
                        </div>

                        <div class="form-group">
                            <div class="row">
                                <div class="col-sm-12">
                                    <label for="toNumbers" class="label-head">Select Recipient</label>
                                    <select name="to_numbers[]" id="toNumbers" class="select2 compose-select"
                                        multiple="multiple" data-placeholder="{{trans('customer.recipient')}}:">

                                        @if(isset($draft) && $draft->formatted_number_to)
                                        @foreach($draft->formatted_number_to_array as $to)
                                        <option selected value="{{$to}}">{{$to}}</option>
                                        @endforeach
                                        @endif
                                        @isset($users_to_contacts)
                                        <optgroup label="Contacts">
                                            @foreach($users_to_contacts as $to)
                                            <option value="{{json_encode($to)}}">{{$to['value']}}</option>
                                            @endforeach
                                        </optgroup>
                                        @endisset

                                        @isset($users_to_groups)
                                        <optgroup label="Groups">
                                            @foreach($users_to_groups as $to)
                                            <option value="{{json_encode($to)}}">{{$to['value']}}</option>
                                            @endforeach
                                        </optgroup>
                                        @endisset
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="toNumbers" class="label-head">Message body</label>
                            <textarea name="body" id="compose-textarea" class="form-control compose-body"
                                placeholder="{{trans('customer.enter_message')}}">{{isset($draft)?$draft->body:''}}</textarea>
                            <div class="text-right">
                                <b id="smsCount"></b> SMS (<b id="smsLength"></b>) Characters left
                            </div>
                        </div>
                        <div class="form-group d-none">
                            <label for="mms_files">{{trans('customer.choose_file')}}:</label>
                            <input type="file" accept="image/*" id="mms_files" class="form-control" name="mms_files[]"
                                multiple>
                        </div>
                        <div class="form-group d-none">

                            <div class="icheck-success d-inline">
                                <input {{isset($draft) && $draft->schedule_datetime?'checked':''}} name="isSchedule"
                                type="checkbox" id="isScheduled">
                                <label for="isScheduled">
                                    {{trans('customer.schedule')}}
                                </label>
                            </div>

                            <input style="display: {{isset($draft) && $draft->schedule_datetime?'block':'none'}}"
                                name="schedule"
                                value="{{isset($draft) && $draft->schedule_datetime?$draft->schedule_datetime->format('m/d/Y h:i A'):''}}"
                                id="schedule" type='text' class="form-control" />
                        </div>

                    </div>
                    <!-- /.card-body -->
                    <div class="card-footer">
                        <div class="float-right">
                            <button id="draft" type="button" class="btn btn-default"><i class="fas fa-pencil-alt"></i>
                                {{trans('customer.draft')}}
                            </button>
                            <button type="submit" class="btn btn-primary"><i class="far fa-envelope"></i>
                                {{trans('customer.send')}}
                            </button>
                        </div>
                        <button id="reset" type="button" class="btn btn-default"><i class="fas fa-times"></i>
                            {{trans('customer.reset')}}
                        </button>
                    </div>
                    <!-- /.card-footer -->
                </form>
            </div>
            <!-- /.card -->
        </div>
        <div class="col-md-4 col-4" id="mobileVersion">
            <div class="iphone" style="background-image: url('{{asset('images/iphone6.png')}}')">
                <div class="border">
                    <div class="responsive-html5-chat">
                        <form class="chat">
                            <span></span>
                            <div class="messages">
                                <div class="message">

                                </div>
                            </div>
                            <input type="text" placeholder="Your message" disabled="">
                            <input type="submit" value="Send" disabled="">
                        </form>
                        <div class="chat-application-sec chat-box-sec d-flex">

                            <div class="chat-box-wrapper">
                                <div class="chat-box-text-sec chat-message-content chat-curve-reply">
                                    <div class="text-sec" id="msg_mobaile_view">

                                    </div>
                                </div>
                            </div>
                            <div class="user-icon-sec">
                                <i class="fa fa-user-circle user-chat-profile" aria-hidden="true"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- /.row -->
</section>
<!-- /.content -->
<input type="hidden" id="meg-time">

@endsection

@section('extra-scripts')
<script src="{{asset('plugins/select2/js/select2.full.min.js')}}"></script>
<script src="{{asset('plugins/daterangepicker/moment.min.js')}}"></script>
<script src="{{asset('plugins/daterangepicker/daterangepicker.js')}}"></script>

<script !src="">
    "use strict";
        var select2 = $('#toNumbers').select2({
            minimumInputLength: 1,
            tags: true,
            tokenSeparators: [",", " "],
        })

        $('#fromNumber').select2({
            theme: 'bootstrap4'
        });

        $('#from_number').select2({
            multiple: false,
            placeholder: 'Select a from number',
        });

        $(function () {
            "use strict";
            $('#schedule').daterangepicker({
                autoUpdateInput: true,
                singleDatePicker: true,
                timePicker: true,
                locale: {
                    format: 'MM/DD/YYYY hh:mm A'
                }
            });
        });

        $(document).on('click', '.activeDevice', function(e){
            const type=$(this).attr('data-type');

            $('.device_type').val(type);

        })

        $('#isScheduled').on('change', function (e) {
            const checked = $(this).is(':checked');
            if (checked) {
                $('#schedule').show();
            } else {
                $('#schedule').hide();
            }
        })

        $('#reset').on('click', function (e) {
            e.preventDefault();
            $(select2).val('').trigger('change');
            $("#compose-textarea").val('');
            let checked = $("#isScheduled").is(':checked');
            if (checked) {
                $('#isScheduled').click().prop("checked", false);
            }
        })

        $('#draft').on('click', function (e) {
            e.preventDefault();
            const from = $('#device_id').val();
            const to = $('#toNumbers').val();
            const body = $('#compose-textarea').val();
            const checked = $("#isScheduled").is(':checked');
            const draft_id = $("#draft_id").val();
            let schedule = '';
            if (checked) {
                schedule = $('#schedule').val();
            }
            $.ajax({
                method: 'post',
                url: '{{route('customer.smsbox.draft.store')}}',
                data: {_token: '{{csrf_token()}}', from, to, body, checked, schedule, draft_id},
                success: function (res) {
                    if (res.status == 'success') {
                        notify('success', res.message);
                        var id = res.data.id;
                        $('#pre_draft').html("<input type='hidden' id='draft_id' name='draft_id' value='" + id + "'/>");

                    } else {
                        notify('danger', res.message);
                    }
                }
            })

        })
        $("#compose-textarea").on("keyup change", function (e) {
            e.preventDefault()
            const checked = $("#isScheduled").is(':checked');
            let dateTime = '';
            if (checked) {
                dateTime = $('#schedule').val();
            } else {
                dateTime = $('#meg-time').val()
            }
            let data = $('#compose-textarea').val();
            let compose = data.replace(/\n/g, "<br />");
            $("#msg_mobaile_view").html(`<div class="chat-text-area"> ${compose} <div>`);

        });
        $('#schedule').on('change', function (e) {
            e.preventDefault()
            let data = $('#compose-textarea').val();
            let compose = data.replace(/\n/g, "<br />");
            const checked = $("#isScheduled").is(':checked');
            let dateTime = '';
            if (checked) {
                dateTime = $('#schedule').val();
            } else {
                dateTime = $('#meg-time').val()
            }
            if (compose) {
                $("#msg_mobaile_view").html(`<div class="chat-date-time">${dateTime}</div>
                <div class="chat-text-area"> ${compose}</div>`);
            }
        });
        $('#isScheduled').on('change', function (e) {
            e.preventDefault()
            let data = $('#compose-textarea').val();
            let compose = data.replace(/\n/g, "<br />");
            const checked = $("#isScheduled").is(':checked');
            let dateTime = '';
            if (checked) {
                dateTime = $('#schedule').val();
            } else {
                dateTime = $('#meg-time').val()
            }
            if (compose) {
                $("#msg_mobaile_view").html(`<div class="chat-date-time">${dateTime}</div>
                <div class="chat-text-area"> ${compose}</div>`);
            }

        });

        $('#phone_number').trigger('change');

</script>
<script>
    const myDate = new Date();
        let daysList = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
        let monthsList = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Aug', 'Oct', 'Nov', 'Dec'];


        let date = myDate.getDate();
        let month = monthsList[myDate.getMonth()];
        let year = myDate.getFullYear();
        let day = daysList[myDate.getDay()];

        let today = `${date} ${month} ${year}, ${day}`;

        let amOrPm;
        let twelveHours = function () {
            if (myDate.getHours() > 12) {
                amOrPm = 'PM';
                let twentyFourHourTime = myDate.getHours();
                let conversion = twentyFourHourTime - 12;
                return `${conversion}`

            } else {
                amOrPm = 'AM';
                return `${myDate.getHours()}`
            }
        };
        let hours = twelveHours();
        let minutes = myDate.getMinutes();

        let currentTime = `${hours}:${minutes} ${amOrPm}`;
        $('#meg-time').val(today + ' ' + currentTime)


        $('#device_id').on('change', function (e) {
            e.preventDefault();
            $('#sim_id').html('');
            let simInfo = $('option:selected', this).attr('data-sim-info');

            if (simInfo) {
                simInfo = JSON.parse(simInfo);
                if (simInfo && typeof simInfo == 'object') {
                    let options = '';
                    for (let sim of simInfo) {
                        let singleSimInfo = sim.split(':');
                        options += `<option value="${singleSimInfo[1]}">${singleSimInfo[2]} (SIM ${parseInt(singleSimInfo[0])+1})</option>`
                    }
                    $('#sim_id').html(options);

                }
            }
        })
</script>
<script>
    (function($){
            $.fn.smsArea = function(options){

                //Generate Ascii Character Array
                var maxCh = 1000;
                var minCh = 0;
                var arrAscii = [];
                for(minCh =1;  minCh < maxCh; minCh++){
                    arrAscii.push(minCh * 160);
                }
                //End

                //Generate Unicode Character Array
                var unMaxCh = 1000;
                var unMinCh = 0;
                var arrUnicode = [];
                for(unMinCh =1;  unMinCh < unMaxCh; unMinCh++){
                    arrUnicode.push(unMinCh * 70);
                }
                //End

                var
                    e = this,
                    cutStrLength = 0,

                    s = $.extend({

                        cut: true,
                        maxSmsNum: 1000,
                        interval: 5,

                        counters: {
                            message: $('#smsCount'),
                            character: $('#smsLength')
                        },

                        lengths: {
                            ascii: arrAscii,
                            unicode: arrUnicode
                        }
                    }, options);


                e.keyup(function(){

                    clearTimeout(this.timeout);
                    this.timeout = setTimeout(function(){

                        var
                            smsType,
                            smsLength = 0,
                            smsCount = -1,
                            charsLeft = 0,
                            text = e.val(),
                            isUnicode = false;

                        for(var charPos = 0; charPos < text.length; charPos++){
                            switch(text[charPos]){
                                case "\n":
                                case "[":
                                case "]":
                                case "\\":
                                case "^":
                                case "{":
                                case "}":
                                case "|":
                                case "€":
                                    smsLength += 2;
                                    break;

                                default:
                                    smsLength += 1;
                            }

                            //!isUnicode && text.charCodeAt(charPos) > 127 && text[charPos] != "€" && (isUnicode = true)
                            if(text.charCodeAt(charPos) > 127 && text[charPos] != "€")
                                isUnicode = true;
                        }

                        if(isUnicode)   smsType = s.lengths.unicode;
                        else                smsType = s.lengths.ascii;

                        for(var sCount = 0; sCount < s.maxSmsNum; sCount++){

                            cutStrLength = smsType[sCount];
                            if(smsLength <= smsType[sCount]){

                                smsCount = sCount + 1;
                                charsLeft = smsType[sCount] - smsLength;
                                break
                            }
                            console.log(sCount, s.maxSmsNum);
                        }

                        if(s.cut) e.val(text.substring(0, cutStrLength));
                        smsCount == -1 && (smsCount = s.maxSmsNum, charsLeft = 0);

                        s.counters.message.html(smsCount);
                        s.counters.character.html(charsLeft);

                    }, s.interval)
                }).keyup();

            }}(jQuery));


        //Start
        $(function(){
            $('#compose-textarea').smsArea();
        })
        $('#fromType').trigger('change');
</script>
@endsection
