@extends('layouts.customer')

@section('title') {{trans('customer.dashboard')}} @endsection

@section('extra-css')
<style>
    body {
        font-family: "Montserrat", sans-serif;
    }

    .content-wrapper {
        background: #fff;
    }

    .header-top h4 {
        color: #051A1A;
        font-size: 20px;
        font-weight: 600;
    }


</style>
@endsection
@section('content')
<!-- Content Header (Page header) -->
<div class="content-header">

</div>
<!-- /.content-header -->

<!-- Main content -->
<div class="content">
    <div class="container-fluid">
        <div class="header-top mt-4 ml-2">
            <div class="row">
                <div class="col-lg-12 col-md-12">
                    <h4>
                        {{trans('customer.dashboard')}}
                    </h4>
                </div>
            </div>
        </div>

        @if(auth('customer')->user()->type=='customer')
        @if(!$sms_send)
        <div class="row">
            <div class="card custom-card">
                <h4 class="pb-1 quick_start_header">{{trans('customer.quick_start')}}</h4>
                <div class="dis-div">
                    <div class="quick_start_topic" id="download_apk_install">
                        <a class="quick_start_ph item_download_apk" href="{{get_settings('link_apk')}}"><i
                                class="fas fa-hand-point-right pr-2"></i>{{trans('customer.download_apk_from_given_link_and_install_it')}}
                        </a>
                    </div>
                    <div class="{{$add_device?'text-cross':''}} quick_start_topic">
                        <a class="quick_start_ph" href="{{route('customer.device.index',['type'=>'add'])}}"><i
                                class="fas fa-hand-point-right pr-2"></i>{{trans('customer.connect_your_phone_with_from_section')}}
                            {{get_settings('app_name')}} {{trans('customer.from')}}
                            "{{trans('customer.add_device')}}" {{trans('customer.section')}}</a>
                    </div>
                    <div class="{{$sending_settings?'text-cross':''}} quick_start_topic">
                        <a class="quick_start_ph"
                            href="{{route('customer.settings.index',['type'=>'sending_settings'])}}"><i
                                class="fas fa-hand-point-right pr-2"></i>{{trans('customer.configure_sending_settings_message')}}
                        </a>
                    </div>
                    <div class="quick_start_topic">
                        <a class="quick_start_ph" href="{{route('customer.smsbox.compose')}}"><i
                                class="fas fa-hand-point-right pr-2"></i>{{trans('customer.start_composing_message')}}
                        </a>
                    </div>
                </div>
            </div>
        </div>
        @endif
        @endif
        <div class="row">
            <div class="col-lg-3 col-md-3 col-sm-6 col-6">
                <div class="card small-widget">
                    <div class="card-body small-box">
                        <span class="card-title-small-box">{{ trans('customer.sms_delivered') }}</span>
                        <div class="total-sms">
                            <div class="count-sms">
                                {{ $smsDeliveredCount }}

                            </div>
                            <div class="sms-img">
                                <i class="fa fa-paper-plane icon" aria-hidden="true"></i>
                            </div>
                            <ul class="bubbles">
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>

                            </ul>
                        </div>
                    </div>
                </div>

            </div>

            <div class="col-lg-3 col-md-3 col-sm-6 col-6">
                <div class="card small-widget">
                    <div class="card-body small-box sms-received">
                        <span class="card-title-small-box">{{ trans('customer.sms_received') }}</span>
                        <div class="total-sms ">
                            <div class="count-sms">
                              {{ $sentPending }}
                            </div>
                            <div class="sms-img">
                                <i class="fas fa-reply-all icon"></i>
                            </div>
                            <ul class="bubbles">
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>

                            </ul>
                        </div>
                    </div>
                </div>

            </div>

            <div class="col-lg-3 col-md-3 col-sm-6 col-6">
                <div class="card small-widget">
                    <div class="card-body small-box failed_to_send">
                        <span class="card-title-small-box">{{ trans('customer.failed_to_send') }}</span>
                        <div class="total-sms">
                            <div class="count-sms">
                               {{ $sentFail }}

                            </div>
                            <div class="sms-img">
                                <i class="fa fa-exclamation-triangle icon"></i>
                            </div>
                            <ul class="bubbles">
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>

                            </ul>
                        </div>
                    </div>
                </div>

            </div>

            <div class="col-lg-3 col-md-3 col-sm-6 col-6">
                <div class="card small-widget">
                    <div class="card-body small-box sms_pending">
                        <span class="card-title-small-box">{{ trans('customer.sms_pending') }}</span>
                        <div class="total-sms">
                            <div class="count-sms">
                               {{ $sentPending }}
                            </div>
                            <div class="sms-img">
                                <i class="fa fa-spinner icon"></i>
                            </div>
                            <ul class="bubbles">
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>

                            </ul>
                        </div>
                    </div>
                </div>

            </div>

            <div class="col-lg-3 col-md-3 col-sm-6 col-6">
                <div class="card small-widget">
                    <div class="card-body small-box">
                        <span class="card-title-small-box">{{ trans('customer.sms_queue') }}</span>
                        <div class="total-sms">
                            <div class="count-sms">
                              {{ $sentQueued }}
                            </div>
                            <div class="sms-img">
                                <i class="fa fa-list-ol icon"></i>
                            </div>
                            <ul class="bubbles">
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>

                            </ul>
                        </div>
                    </div>
                </div>

            </div>

            <div class="col-lg-3 col-md-3 col-sm-6 col-6">
                <div class="card small-widget">
                    <div class="card-body small-box sms-received">
                        <span class="card-title-small-box">{{ trans('customer.device_added') }}</span>
                        <div class="total-sms ">
                            <div class="count-sms">
                              {{ $device_added }}
                            </div>
                            <div class="sms-img">
                                <i class="fa fa-mobile icon"></i>
                            </div>
                            <ul class="bubbles">
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>

                            </ul>
                        </div>
                    </div>
                </div>

            </div>

            <div class="col-lg-3 col-md-3 col-sm-6 col-6">
                <div class="card small-widget">
                    <div class="card-body small-box failed_to_send">
                        <span class="card-title-small-box">{{ trans('customer.total_contact') }}</span>
                        <div class="total-sms">
                            <div class="count-sms">
                           {{ $total_contact }}
                            </div>
                            <div class="sms-img">
                                <i class="fa fa-phone icon"></i>
                            </div>
                            <ul class="bubbles">
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>

                            </ul>
                        </div>
                    </div>
                </div>

            </div>

            <div class="col-lg-3 col-md-3 col-sm-6 col-6">
                <div class="card small-widget">
                    <div class="card-body small-box sms_pending">
                        <span class="card-title-small-box">{{ trans('customer.total_group') }}</span>
                        <div class="total-sms">
                            <div class="count-sms">
                         {{ $total_group }}
                            </div>
                            <div class="sms-img">
                                <i class="fa fa-users icon"></i>
                            </div>
                            <ul class="bubbles">
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>

                            </ul>
                        </div>
                    </div>
                </div>

            </div>

        </div>


        <div class="row mt-5">
            <div class="col-sm-6">
                <div class="card custom-chart-card">
                    <div id="inbox-chart"></div>
                </div>
            </div>
            <div class="col-sm-6">
                <div class="card custom-chart-card">
                    <div id="response-chart"></div>
                </div>
            </div>
        </div>
        <!-- /.row -->
    </div><!-- /.container-fluid -->
</div>
<!-- /.content -->
@endsection

@section('extra-scripts')
<script src="{{asset('js/apex-chart.js')}}"></script>
  {{-- <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script> --}}
  <script>
    "use strict";
        var options = {
          series: [{
          name: 'Inbox',
          data: @json($chart_inbox)
        }],
          chart: {
          height: 350,
          type: 'line',
        },
        forecastDataPoints: {
          count: 7
        },
        stroke: {
          width: 5,
          curve: 'smooth'
        },
      xaxis: {
          categories: @json($weekDates),
          tickAmount: 7
  },
        title: {
          text: 'Total Inbox',
          align: 'left',
          style: {
            fontSize: "16px",
            color: '#666'
          }
        },
        fill: {
          type: 'gradient',
          gradient: {
            shade: 'dark',
            gradientToColors: [ '#FDD835'],
            shadeIntensity: 1,
            type: 'horizontal',
            opacityFrom: 1,
            opacityTo: 1,
            stops: [0, 100, 100, 100]
          },
        },
        yaxis: {
          min: 0,
          max: 1000
        }
        };
        var chart = new ApexCharts(document.querySelector("#inbox-chart"), options);
        chart.render();
        var options = {
            series: [{
            name: 'Response',
            data:  @json($weeklyResponseArray)
          }],
            chart: {
            height: 350,
            type: 'area'
          },
          dataLabels: {
            enabled: false
          },
          stroke: {
            curve: 'smooth'
          },
          xaxis: {
          categories: @json($weekDates),
          tickAmount: 7
  },
          title: {
          text: 'Total Response',
          align: 'left',
          style: {
            fontSize: "16px",
            color: '#666'
          }
        },
          tooltip: {
            x: {
              format: 'dd/MM/yy HH:mm'
            },
          },
          };
          var chart = new ApexCharts(document.querySelector("#response-chart"), options);
          chart.render();
  </script>
@endsection
