@extends('layouts.customer')

@section('title') Campaign Statistic @endsection

@section('extra-css')
    <link rel="stylesheet" href="{{asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')}}">
    <link rel="stylesheet" href="{{asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css')}}">
    <style>
        .card-title-small-box {
            font-size: 25px;
            color: #000;
        }
        .total-sms {
            padding: 0px 20px !important;
        }
        .total-sms .count-sms span{
            font-size: 30px !important;
            font-weight: 500;
        }
        .contact-data{
            margin: 0px 10px;
        }
    </style>
@endsection

@section('content')
    <!-- Main content -->
    {{-- <section class="content">
        <div class="row">
            <div class="col-lg-6 col-sm-6 mt-3">
                <div class="card">
                    <div class="card-header">
                        <h2 class="card-title">Running</h2>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body table-body">
                        <table id="campaignReports" class="table table-striped table-bordered dt-responsive nowrap">
                            <thead>
                            <tr>
                                <th>@lang('customer.from')</th>
                                <th>@lang('customer.to')</th>
                                <th>@lang('customer.message')</th>
                                <th>@lang('customer.schedule_at')</th>
                            </tr>
                            </thead>
                            <tbody>
                            @if($messageRunningLogs->isNotEmpty())
                                @foreach($messageRunningLogs as $message_log)
                                    <tr>
                                        <td>{{$message_log->from}}</td>
                                        <td>{{$message_log->to}}</td>
                                        <td>
                                            <div class="show-more">
                                                {{$message_log->body}}
                                            </div>
                                        </td>
                                        <td>{{(formatDate($message_log->schedule_datetime))}}</td>
                                    </tr>
                                @endforeach
                            @else
                                <tr class="text-center">
                                    <td colspan="5"><strong>No Data Available</strong></td>
                                </tr>
                            @endif
                            </tbody>
                        </table>
                        <div class="mt-2">
                            {{$messageRunningLogs->appends(['running' => $messageRunningLogs->currentPage()])->links()}}
                        </div>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>

            <div class="col-lg-6 col-sm-6 mt-3">
                <div class="card">
                    <div class="card-header">
                        <h2 class="card-title">Paused</h2>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body table-body">
                        <table id="campaignReports" class="table table-striped table-bordered dt-responsive nowrap">
                            <thead>
                            <tr>
                                <th>@lang('customer.from')</th>
                                <th>@lang('customer.to')</th>
                                <th>@lang('customer.message')</th>
                                <th>@lang('customer.schedule_at')</th>
                            </tr>
                            </thead>
                            <tbody>
                            @if($messagePausedLogs->isNotEmpty())
                                @foreach($messagePausedLogs as $message_log)
                                    <tr>
                                        <td>{{$message_log->from}}</td>
                                        <td>{{$message_log->to}}</td>
                                        <td>
                                            <div class="show-more">
                                                {{$message_log->body}}
                                            </div>
                                        </td>
                                        <td>{{formatDate($message_log->schedule_datetime)}}</td>
                                    </tr>
                                @endforeach
                            @else
                                <tr class="text-center">
                                    <td colspan="5"><strong>No Data Available</strong></td>
                                </tr>
                            @endif
                            </tbody>
                        </table>
                        <div class="mt-2">
                            {{$messagePausedLogs->appends(['paused' => $messagePausedLogs->currentPage()])->links()}}
                        </div>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>

            <div class="col-lg-6 col-sm-6 mt-3">
                <div class="card">
                    <div class="card-header">
                        <h2 class="card-title">Failed</h2>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body table-body">
                        <table id="messageFailedLogs" class="table table-striped table-bordered dt-responsive nowrap">
                            <thead>
                            <tr>
                                <th>@lang('customer.from')</th>
                                <th>@lang('customer.to')</th>
                                <th>@lang('customer.message')</th>
                                <th>@lang('customer.response_code')</th>
                                <th>@lang('customer.failed_at')</th>
                            </tr>
                            </thead>
                            <tbody>
                            @if($messageFailedLogs->isNotEmpty())
                                @foreach($messageFailedLogs as $message_log)
                                    <tr>
                                        <td>{{$message_log->from}}</td>
                                        <td>{{$message_log->to}}</td>
                                        <td>
                                            <div class="show-more">
                                                {{$message_log->body}}
                                            </div>
                                        </td>
                                        <td>{{$message_log->response_code}}</td>
                                        <td>{{formatDate($message_log->updated_at)}}</td>
                                    </tr>
                                @endforeach
                            @else
                                <tr class="text-center">
                                    <td colspan="5"><strong>No Data Available</strong></td>
                                </tr>
                            @endif
                            </tbody>
                        </table>
                        <div class="mt-2">
                            {{$messageFailedLogs->appends(['failed' => $messageFailedLogs->currentPage()])->links()}}
                        </div>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>

            <div class="col-lg-6 col-sm-6 mt-3">
                <div class="card">
                    <div class="card-header">
                        <h2 class="card-title">Delivered</h2>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body table-body">
                        <table id="campaignReports" class="table table-striped table-bordered dt-responsive nowrap">
                            <thead>
                            <tr>
                                <th>@lang('customer.from')</th>
                                <th>@lang('customer.to')</th>
                                <th>@lang('customer.message')</th>
                                <th>@lang('customer.schedule_at')</th>
                                <th>@lang('customer.delivered_at')</th>
                            </tr>
                            </thead>
                            <tbody>
                            @if($messageDeliveredLogs->isNotEmpty())
                                @foreach($messageDeliveredLogs as $message_log)
                                    <tr>
                                        <td>{{$message_log->from}}</td>
                                        <td>{{$message_log->to}}</td>
                                        <td>
                                            <div class="show-more">
                                                {{$message_log->body}}
                                            </div>
                                        </td>
                                        <td>{{($message_log->schedule_datetime)}}</td>
                                        <td>{{formatDate($message_log->updated_at)}}</td>
                                    </tr>
                                @endforeach
                            @else
                                <tr class="text-center">
                                    <td colspan="5"><strong>No Data Available</strong></td>
                                </tr>
                            @endif
                            </tbody>
                        </table>
                        <div class="mt-2">
                            {{$messageDeliveredLogs->appends(['delivered' => $messageDeliveredLogs->currentPage()])->links()}}
                        </div>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>

            <!-- /.col -->
        </div>
        <!-- /.row -->
    </section> --}}
    <section class="content">
        <div class="row">
            <div class="col-lg-4 col-md-4 col-sm-6 col-6">
                <div class="card small-widget">
                    <div class="card-body small-box">
                        <span class="card-title-small-box">{{ trans('customer.total_contact') }}</span>
                        <div class="total-sms">
                            <div class="count-sms">
                                   <span> {{ $total_contact }} </span>
                            </div>
                            <div class="sms-img">
                                <i class="fa fa-phone icon" aria-hidden="true"></i>
                            </div>
                            <ul class="bubbles">
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>

                            </ul>
                        </div>
                    </div>
                </div>

            </div>

            <div class="col-lg-4 col-md-4 col-sm-6 col-6">
                <div class="card small-widget">
                    <div class="card-body small-box sms-received">
                        <span class="card-title-small-box">{{ trans('customer.total_delivered') }}</span>
                        <div class="total-sms ">
                            <div class="count-sms">
                              <span>{{ $totald_delivered }}</span>
                            </div>
                            <div class="sms-img">
                                <i class="fa fa-paper-plane icon"></i>
                            </div>
                            <ul class="bubbles">
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>

                            </ul>
                        </div>
                    </div>
                </div>

            </div>

            <div class="col-lg-4 col-md-4 col-sm-6 col-6">
                <div class="card small-widget">
                    <div class="card-body small-box failed_to_send">
                        <span class="card-title-small-box">{{ trans('customer.total_falied') }}</span>
                        <div class="total-sms">
                            <div class="count-sms">
                                <span>{{ $total_falied }}</span>
                            </div>
                            <div class="sms-img">
                                <i class="fa fa-exclamation-triangle icon"></i>
                            </div>
                            <ul class="bubbles">
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>

                            </ul>
                        </div>
                    </div>
                </div>

            </div>
        </div>
        <div class="row mt-5">
            <div class="col-lg-12 col-md-12 col-12">
                <div class="card pt-0 pb-0">
                    <div class="card-header">

                <ul class="nav nav-pills mb-3 mt-5" id="pills-tab" role="tablist">
                    <li class="nav-item contact-data">
                      <a class="nav-link custom nav-link-hover active" id="pills-home-tab" data-toggle="pill" href="#pills-home" role="tab" aria-controls="pills-home" aria-selected="true">Running</a>
                    </li>
                    <li class="nav-item contact-data">
                      <a class="nav-link custom nav-link-hover" id="pills-profile-tab" data-toggle="pill" href="#pills-profile" role="tab" aria-controls="pills-profile" aria-selected="false">Paused</a>
                    </li>
                    <li class="nav-item contact-data">
                      <a class="nav-link custom nav-link-hover" id="pills-contact-tab" data-toggle="pill" href="#pills-contact" role="tab" aria-controls="pills-contact" aria-selected="false">Failed</a>
                    </li>
                    <li class="nav-item contact-data">
                        <a class="nav-link custom nav-link-hover" id="pills-contact-tab" data-toggle="pill" href="#pills-falied" role="tab" aria-controls="pills-contact" aria-selected="false">Delivered</a>
                      </li>
                  </ul>
                </div>

                <div class="card-body">
                  <div class="tab-content" id="pills-tabContent">
                    <div class="tab-pane fade show active" id="pills-home" role="tabpanel" aria-labelledby="pills-home-tab">
                        <div class="row">
                            <div class="col-lg-9 col-sm-12 mt-3">
                                    <div class=" table-body">
                                        <table id="campaignReports" class="table table-striped table-bordered dt-responsive nowrap">
                                            <thead>
                                            <tr>
                                                <th>@lang('customer.from')</th>
                                                <th>@lang('customer.to')</th>
                                                <th>@lang('customer.message')</th>
                                                <th>@lang('customer.schedule_at')</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            @if($messageRunningLogs->isNotEmpty())
                                                @foreach($messageRunningLogs as $message_log)
                                                    <tr>
                                                        <td>{{$message_log->from}}</td>
                                                        <td>{{$message_log->to}}</td>
                                                        <td>
                                                            <div class="show-more">
                                                                {{$message_log->body}}
                                                            </div>
                                                        </td>
                                                        <td>{{(formatDate($message_log->schedule_datetime))}}</td>
                                                    </tr>
                                                @endforeach
                                            @else
                                                <tr class="text-center">
                                                    <td colspan="5"><strong>No Data Available</strong></td>
                                                </tr>
                                            @endif
                                            </tbody>
                                        </table>
                                        <div class="mt-2">
                                            {{$messageRunningLogs->appends(['running' => $messageRunningLogs->currentPage()])->links()}}
                                        </div>
                                    </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="pills-profile" role="tabpanel" aria-labelledby="pills-profile-tab">
                        <div class="row">
                            <div class="col-lg-9 col-sm-12 mt-3">
                                    <div class=" table-body">
                                        <table id="campaignReports" class="table table-striped table-bordered dt-responsive nowrap">
                                            <thead>
                                            <tr>
                                                <th>@lang('customer.from')</th>
                                                <th>@lang('customer.to')</th>
                                                <th>@lang('customer.message')</th>
                                                <th>@lang('customer.schedule_at')</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            @if($messagePausedLogs->isNotEmpty())
                                                @foreach($messagePausedLogs as $message_log)
                                                    <tr>
                                                        <td>{{$message_log->from}}</td>
                                                        <td>{{$message_log->to}}</td>
                                                        <td>
                                                            <div class="show-more">
                                                                {{$message_log->body}}
                                                            </div>
                                                        </td>
                                                        <td>{{formatDate($message_log->schedule_datetime)}}</td>
                                                    </tr>
                                                @endforeach
                                            @else
                                                <tr class="text-center">
                                                    <td colspan="5"><strong>No Data Available</strong></td>
                                                </tr>
                                            @endif
                                            </tbody>
                                        </table>
                                        <div class="mt-2">
                                            {{$messagePausedLogs->appends(['paused' => $messagePausedLogs->currentPage()])->links()}}
                                        </div>
                                    </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="pills-contact" role="tabpanel" aria-labelledby="pills-contact-tab">
                        <div class="row">
                            <div class="col-lg-9 col-sm-12 mt-3">
                                    <div class="card-body table-body">
                                        <table id="messageFailedLogs" class="table table-striped table-bordered dt-responsive nowrap">
                                            <thead>
                                            <tr>
                                                <th>@lang('customer.from')</th>
                                                <th>@lang('customer.to')</th>
                                                <th>@lang('customer.message')</th>
                                                <th>@lang('customer.response_code')</th>
                                                <th>@lang('customer.failed_at')</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            @if($messageFailedLogs->isNotEmpty())
                                                @foreach($messageFailedLogs as $message_log)
                                                    <tr>
                                                        <td>{{$message_log->from}}</td>
                                                        <td>{{$message_log->to}}</td>
                                                        <td>
                                                            <div class="show-more">
                                                                {{$message_log->body}}
                                                            </div>
                                                        </td>
                                                        <td>{{$message_log->response_code}}</td>
                                                        <td>{{formatDate($message_log->updated_at)}}</td>
                                                    </tr>
                                                @endforeach
                                            @else
                                                <tr class="text-center">
                                                    <td colspan="5"><strong>No Data Available</strong></td>
                                                </tr>
                                            @endif
                                            </tbody>
                                        </table>
                                        <div class="mt-2">
                                            {{$messageFailedLogs->appends(['failed' => $messageFailedLogs->currentPage()])->links()}}
                                        </div>
                                    </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="pills-falied" role="tabpanel" aria-labelledby="pills-contact-tab">
                        <div class="row">
                            <div class="col-lg-9 col-sm-12 mt-3">
                                    <div class="card-body table-body">
                                        <table id="campaignReports" class="table table-striped table-bordered dt-responsive nowrap">
                                            <thead>
                                            <tr>
                                                <th>@lang('customer.from')</th>
                                                <th>@lang('customer.to')</th>
                                                <th>@lang('customer.message')</th>
                                                <th>@lang('customer.schedule_at')</th>
                                                <th>@lang('customer.delivered_at')</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            @if($messageDeliveredLogs->isNotEmpty())
                                                @foreach($messageDeliveredLogs as $message_log)
                                                    <tr>
                                                        <td>{{$message_log->from}}</td>
                                                        <td>{{$message_log->to}}</td>
                                                        <td>
                                                            <div class="show-more">
                                                                {{$message_log->body}}
                                                            </div>
                                                        </td>
                                                        <td>{{($message_log->schedule_datetime)}}</td>
                                                        <td>{{formatDate($message_log->updated_at)}}</td>
                                                    </tr>
                                                @endforeach
                                            @else
                                                <tr class="text-center">
                                                    <td colspan="5"><strong>No Data Available</strong></td>
                                                </tr>
                                            @endif
                                            </tbody>
                                        </table>
                                        <div class="mt-2">
                                            {{$messageDeliveredLogs->appends(['delivered' => $messageDeliveredLogs->currentPage()])->links()}}
                                        </div>
                                    </div>
                            </div>
                        </div>
                    </div>
                  </div>
                </div>

            </div>

        </div>
        </div>
    </section>
    <!-- /.content -->
@endsection

@section('extra-scripts')
    <script>
        $(".show-more").css('overflow', 'hidden').readmore({collapsedHeight: 20});
    </script>
@endsection


