@extends('layouts.customer')

@section('title') {{trans('customer.developer')}} @endsection

@section('extra-css')
<style>
    .c-pointer {
        cursor: pointer;
    }
    .btn-link{
        width: 100% !important;
        text-align: left;
    }

    #accordion .card-header{
        background: #d9d7d761 !important;
    }
    .card-header {
    border-bottom: 1px solid var(--primary-border) !important;
}
.card {
    margin-bottom: 1.25rem;
    box-shadow: 0px 8px 15px rgba(0, 0, 0, 0.1) !important;
    transition: all 0.3s ease 0s;
    position: relative;
    display: flex;
    flex-direction: column;
    min-width: 0;
    word-wrap: break-word;
    background-color: #fff;
    background-clip: border-box;
    border: 0 solid #F6F6F6;
    border-radius: .25rem;
    padding: 10px !important;
}
.btn {
    display: inline-block;
    font-weight: 400 !important;
    line-height: 1.5;
    color: #495057;
    vertical-align: middle;
    user-select: none;
    background-color: transparent;
    border: 1px solid transparent;
    padding: .47rem .75rem;
    font-size: .9rem;
    border-radius: .25rem;
    transition: color .15s ease-in-out,background-color .15s ease-in-out,border-color .15s ease-in-out,box-shadow .15s ease-in-out;
    box-shadow: 0px 8px 15px rgba(0, 0, 0, 0.1) !important;
}
.card-body{
    font-weight: 400 !important;
    font-size: .9rem !important;
}
</style>

@endsection

@section('content')
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h2 class="card-title">{{trans('customer.developer')}}</h2>
                        <div class="float-right">

                        </div>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body">
                        <div class="row">
                            <div class="col-lg-12 cpl-md-12">
                                <a target="_blank" href="https://documenter.getpostman.com/view/15947626/UzJLPGYF" class="btn btn-primary float-right text-white">{{trans('API Documentation')}}</a>
                            </div>
                            <div class="col-md-6 mx-auto">
                                <form action="{{route('customer.authorization.token.store')}}" method="post" id="apiForm">
                                    @csrf
                                    <div class="form-group">
                                            <label for="">Access Key</label>
                                            <div class="input-group date" id="reservationdatetime"
                                                 data-target-input="nearest">
                                                <input class="form-control" type="text"
                                                       value="{{isset($authorization_token->access_token)?$authorization_token->access_token:''}}" id="accessKey">
                                                <div class="input-group-append" data-target="#reservationdatetime"
                                                     data-toggle="datetimepicker">
                                                    <div class="input-group-text">
                                                        <i onclick="myFunction()" onmouseout="outFunc()"
                                                           class="fa fa-copy c-pointer"></i>
                                                                <i  class="fas fa-sync-alt ml-3 c-pointer" id="refresh"></i>
                                                    </div>
                                                </div>
                                            </div>
                                    </div>

                                </form>
                            </div>
                            <div class="col-md-12 mt-4">
                                <div id="accordion">

                                    <div class="card">
                                        <div class="card-header" id="headingOne">
                                            <h5 class="mb-0">
                                                <button class="btn btn-link" data-toggle="collapse" data-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                                    Add Device
                                                </button>
                                            </h5>
                                        </div>
                                        <div id="collapseOne" class="collapse show" aria-labelledby="headingOne" data-parent="#accordion">
                                            <div class="card-body">
                                                <b> API URL:</b> <b>YOUR_DOMAIN</b>/api/add/device
                                              <br>
                                             <div>
                                                Content-Type: application/json
                                             </div>
                                              <div>  Accept: application/json</div>
                                             <div>
                                                Authorization: Bearer {{isset($authorization_token->access_token)?$authorization_token->access_token:''}}
                                            </div>
                                                <small class="float-right mt-3 d-block"><b>Note:</b> Authorize user only access</small>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card">
                                        <div class="card-header" id="headingTwo">
                                            <h5 class="mb-0">
                                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                                    Get Devices
                                                </button>
                                            </h5>
                                        </div>
                                        <div id="collapseTwo" class="collapse" aria-labelledby="headingTwo" data-parent="#accordion">
                                            <div class="card-body">
                                                <b>API KEY:</b> <b>YOUR_DOMAIN</b>/api/get/devices
                                                <br>
                                                <div>
                                                   Content-Type: application/json
                                                </div>
                                                 <div>  Accept: application/json</div>
                                                <div>
                                                   Authorization: Bearer {{isset($authorization_token->access_token)?$authorization_token->access_token:''}}
                                               </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card">
                                        <div class="card-header" id="headingThree">
                                            <h5 class="mb-0">
                                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapseThree" aria-expanded="false" aria-controls="collapseTwo">
                                                    Get Subscriber
                                                </button>
                                            </h5>
                                        </div>
                                        <div id="collapseThree" class="collapse" aria-labelledby="headingThree" data-parent="#accordion">
                                            <div class="card-body">
                                                <b>API KEY:</b> <b>YOUR_DOMAIN</b>/api/get/subscriber/id?device_id=335
                                                <br>
                                                <div>
                                                   Content-Type: application/json
                                                </div>
                                                 <div>  Accept: application/json</div>
                                                <div>
                                                   Authorization: Bearer {{isset($authorization_token->access_token)?$authorization_token->access_token:''}}
                                               </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card">
                                        <div class="card-header" id="headingFour">
                                            <h5 class="mb-0">
                                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                                                    Quick Send
                                                </button>
                                            </h5>
                                        </div>
                                        <div id="collapseFour" class="collapse" aria-labelledby="headingFour" data-parent="#accordion">
                                            <div class="card-body">
                                                <b>API KEY:</b> <b>YOUR_DOMAIN</b>/api/sent/compose
                                                <br>
                                                <div>
                                                   Content-Type: application/json
                                                </div>
                                                 <div>  Accept: application/json</div>
                                                <div>
                                                   Authorization: Bearer {{isset($authorization_token->access_token)?$authorization_token->access_token:''}}
                                               </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card">
                                        <div class="card-header" id="headingInboxList">
                                            <h5 class="mb-0">
                                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapseInboxList" aria-expanded="false" aria-controls="collapseTwo">
                                                    Inbox List
                                                </button>
                                            </h5>
                                        </div>
                                        <div id="collapseInboxList" class="collapse" aria-labelledby="headingInboxList" data-parent="#accordion">
                                            <div class="card-body">
                                                <b>API KEY:</b> <b>YOUR_DOMAIN</b>/api/inbox/list?page=1
                                                <br>
                                                <div>
                                                   Content-Type: application/json
                                                </div>
                                                 <div>  Accept: application/json</div>
                                                <div>
                                                   Authorization: Bearer {{isset($authorization_token->access_token)?$authorization_token->access_token:''}}
                                               </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card">
                                        <div class="card-header" id="headingSentList">
                                            <h5 class="mb-0">
                                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapseSentList" aria-expanded="false" aria-controls="collapseTwo">
                                                    Sent List
                                                </button>
                                            </h5>
                                        </div>
                                        <div id="collapseSentList" class="collapse" aria-labelledby="headingSentList" data-parent="#accordion">
                                            <div class="card-body">
                                                <b>API KEY:</b> <b>YOUR_DOMAIN</b>/api/sent/list?page=1
                                                <br>
                                                <div>
                                                   Content-Type: application/json
                                                </div>
                                                 <div>  Accept: application/json</div>
                                                <div>
                                                   Authorization: Bearer {{isset($authorization_token->access_token)?$authorization_token->access_token:''}}
                                               </div>
                                            </div>
                                        </div>
                                    </div> 
                                    <div class="card">
                                        <div class="card-header" id="headingCampaignList">
                                            <h5 class="mb-0">
                                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapsedCampaignList" aria-expanded="false" aria-controls="collapseTwo">
                                                    Campaign List
                                                </button>
                                            </h5>
                                        </div>
                                        <div id="collapsedCampaignList" class="collapse" aria-labelledby="headingCampaignList" data-parent="#accordion">
                                            <div class="card-body">
                                                <b>API KEY:</b> <b>YOUR_DOMAIN</b>/api/campaign/list
                                                <br>
                                                <div>
                                                   Content-Type: application/json
                                                </div>
                                                 <div>  Accept: application/json</div>
                                                <div>
                                                   Authorization: Bearer {{isset($authorization_token->access_token)?$authorization_token->access_token:''}}
                                               </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card">
                                        <div class="card-header" id="headingCampaignCreate">
                                            <h5 class="mb-0">
                                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapsedCampaignCreate" aria-expanded="false" aria-controls="collapseTwo">
                                                    Create Campaign
                                                </button>
                                            </h5>
                                        </div>
                                        <div id="collapsedCampaignCreate" class="collapse" aria-labelledby="headingCampaignCreate" data-parent="#accordion">
                                            <div class="card-body">
                                                <b>API KEY:</b> <b>YOUR_DOMAIN</b>/api/campaign/store
                                                <br>
                                                <div>
                                                   Content-Type: application/json
                                                </div>
                                                 <div>  Accept: application/json</div>
                                                <div>
                                                   Authorization: Bearer {{isset($authorization_token->access_token)?$authorization_token->access_token:''}}
                                               </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card">
                                        <div class="card-header" id="headingSMSTemplate">
                                            <h5 class="mb-0">
                                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapsedSMSTemplate" aria-expanded="false" aria-controls="collapseTwo">
                                                    Get SMS Template
                                                </button>
                                            </h5>
                                        </div>
                                        <div id="collapsedSMSTemplate" class="collapse" aria-labelledby="headingSMSTemplate" data-parent="#accordion">
                                            <div class="card-body">
                                                <b>API KEY:</b> <b>YOUR_DOMAIN</b>/api/sms/template
                                                <br>
                                                <div>
                                                   Content-Type: application/json
                                                </div>
                                                 <div>  Accept: application/json</div>
                                                <div>
                                                   Authorization: Bearer {{isset($authorization_token->access_token)?$authorization_token->access_token:''}}
                                               </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card">
                                        <div class="card-header" id="headingContacts">
                                            <h5 class="mb-0">
                                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapsedContacts" aria-expanded="false" aria-controls="collapseTwo">
                                                    Get Contacts
                                                </button>
                                            </h5>
                                        </div>
                                        <div id="collapsedContacts" class="collapse" aria-labelledby="headingContacts" data-parent="#accordion">
                                            <div class="card-body">
                                                <b>API KEY:</b> <b>YOUR_DOMAIN</b>/api/contacts
                                                <br>
                                                <div>
                                                   Content-Type: application/json
                                                </div>
                                                 <div>  Accept: application/json</div>
                                                <div>
                                                   Authorization: Bearer {{isset($authorization_token->access_token)?$authorization_token->access_token:''}}
                                               </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card">
                                        <div class="card-header" id="headingcontactDetails">
                                            <h5 class="mb-0">
                                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapsedcontactDetails" aria-expanded="false" aria-controls="collapseTwo">
                                                    Contact Details
                                                </button>
                                            </h5>
                                        </div>
                                        <div id="collapsedcontactDetails" class="collapse" aria-labelledby="headingcontactDetails" data-parent="#accordion">
                                            <div class="card-body">
                                                <b>API KEY:</b> <b>YOUR_DOMAIN</b>/api/contact/details?number=+8801735990599
                                                <br>
                                                <div>
                                                   Content-Type: application/json
                                                </div>
                                                 <div>  Accept: application/json</div>
                                                <div>
                                                   Authorization: Bearer {{isset($authorization_token->access_token)?$authorization_token->access_token:''}}
                                               </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.card-body -->
            </div>
            <!-- /.card -->
        </div>
        <!-- /.col -->
        </div>
        <!-- /.row -->
    </section>
    <!-- /.content -->
@endsection

@section('extra-scripts')
    <script>
        $(document).on('click', '#refresh', function (e){
            $('#apiForm').submit();
        })
        function myFunction() {
            var copyText = document.getElementById("accessKey");
            copyText.select();
            copyText.setSelectionRange(0, 99999);
            navigator.clipboard.writeText(copyText.value);

            var tooltip = document.getElementById("keyToolTip");
            tooltip.innerHTML = "Copied: " + copyText.value;
        }

        function outFunc() {
            var tooltip = document.getElementById("keyToolTip");
            tooltip.innerHTML = "Copy to clipboard";
        }
    </script>
@endsection

