@extends('layouts.admin')

@section('title') Dashboard @endsection

@section('content')
    <!-- Content Header (Page header) -->
    <div class="content-header">

    </div>
    <!-- /.content-header -->

    <!-- Main content -->
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-3 col-md-3 col-sm-6 col-6">
                  <div class="card small-widget">
                      <div class="card-body small-box">
                          <span class="card-title-small-box">@lang('admin.dashboard.today_inbox')</span>
                          <div class="total-sms">
                              <div class="count-sms">
                                {{$newMessageCount}}
                              </div>
                              <div class="sms-img">
                                  <i class="fa fa-inbox icon" aria-hidden="true"></i>
                              </div>
                              <ul class="bubbles">
                                  <li class="bubble"></li>
                                  <li class="bubble"></li>
                                  <li class="bubble"></li>
                                  <li class="bubble"></li>
                                  <li class="bubble"></li>
                                  <li class="bubble"></li>
                                  <li class="bubble"></li>
                                  <li class="bubble"></li>
                                  <li class="bubble"></li>
  
                              </ul>
                          </div>
                      </div>
                  </div>
  
               </div>
               <div class="col-lg-3 col-md-3 col-sm-6 col-6">
                <div class="card small-widget">
                    <div class="card-body small-box">
                        <span class="card-title-small-box">@lang('admin.dashboard.today_sent')</span>
                        <div class="total-sms">
                            <div class="count-sms">
                              {{$newMessageCount}}
                            </div>
                            <div class="sms-img">
                                <i class="fa fa-paper-plane icon" aria-hidden="true"></i>
                            </div>
                            <ul class="bubbles">
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>
                                <li class="bubble"></li>

                            </ul>
                        </div>
                    </div>
                </div>

             </div>
             <div class="col-lg-3 col-md-3 col-sm-6 col-6">
              <div class="card small-widget">
                  <div class="card-body small-box sms-received">
                      <span class="card-title-small-box">@lang('admin.dashboard.total_inbox')</span>
                      <div class="total-sms">
                          <div class="count-sms">
                            {{$totalInbox}}
                          </div>
                          <div class="sms-img">
                              <i class="fa fa-envelope icon" aria-hidden="true"></i>
                            
                          </div>
                          <ul class="bubbles">
                              <li class="bubble"></li>
                              <li class="bubble"></li>
                              <li class="bubble"></li>
                              <li class="bubble"></li>
                              <li class="bubble"></li>
                              <li class="bubble"></li>
                              <li class="bubble"></li>
                              <li class="bubble"></li>
                              <li class="bubble"></li>

                          </ul>
                      </div>
                  </div>
              </div>

           </div>
           <div class="col-lg-3 col-md-3 col-sm-6 col-6">
            <div class="card small-widget">
                <div class="card-body small-box sms-received">
                    <span class="card-title-small-box">@lang('admin.dashboard.total_sent')</span>
                    <div class="total-sms">
                        <div class="count-sms">
                          {{$totalSent}}
                        </div>
                        <div class="sms-img">
                            <i class="fa fa-share-square icon" aria-hidden="true"></i>
                        </div>

                        <ul class="bubbles">
                            <li class="bubble"></li>
                            <li class="bubble"></li>
                            <li class="bubble"></li>
                            <li class="bubble"></li>
                            <li class="bubble"></li>
                            <li class="bubble"></li>
                            <li class="bubble"></li>
                            <li class="bubble"></li>
                            <li class="bubble"></li>

                        </ul>
                    </div>
                </div>
            </div>

         </div>
                <!-- ./col -->
            </div>


            <div class="row">
               <div class="col-sm-6">
                    <div class="card custom-chart-card">
                        <div id="customer-chart"></div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="card custom-chart-card">
                        <div id="revenue-chart"></div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-lg-6 col-md-12 col-12">
                    @if (isset($latest_customers) && $latest_customers)
                    <div class="new-customer-table">
                        <div class="card card-table">
                            <div class="card-header table-head">
                                <h4>@lang('admin.new_customers')</h4>
                            </div>
                            <div class="card-body pt-0">
                                <div class="new-customer-list">
                                    <div class="table">
                                        <table class="latest-list">
                                            <thead>
                                                <tr>
                                                    <th>@lang('admin.profile_pichter')</th>
                                                    <th>@lang('admin.customer_info')</th>
                                                    <th>@lang('admin.status')</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach ($latest_customers as $latest_customer)
                                                <tr>
                                                    <td>
                                                        <div class="profile">
                                                            <img src="{{ asset("uploads/" . $latest_customer->profile_picture) }}" alt="" >
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="customer-info">
                                                            <h6>{{ $latest_customer->fullname }}</h6>
                                                            <span>{{ $latest_customer->email }}</span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="status">
                                                            @if ($latest_customer->status == 'Active')
                                                            <span class="text-success">{{ $latest_customer->status }}</span>
                                                            @else
                                                            <span class="text-danger">{{ $latest_customer->status }}</span>
                                                            @endif

                                                        </div>
                                                    </td>
                                                </tr>
                                                @endforeach

                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif

                </div>
                <div class="col-lg-6 col-md-12 col-12">
                    @if (isset($transactions) && $transactions)
                    <div class="transaction">
                        <div class="card card-table transaction-table">
                            <div class="card-header table-head">
                                <h4>@lang('admin.latest_transaction')</h4>
                            </div>
                            <div class="card-body pt-0">
                                <div class="new-customer-list">
                                    <div class="table">
                                        <table class="latest-list">
                                            <thead>
                                                <tr>
                                                    <th>@lang('admin.customer_details')</th>
                                                    <th>@lang('admin.plan_name')</th>
                                                    <th>@lang('admin.plan_price')</th>
                                                    <th>@lang('admin.type')</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach ($transactions as $transaction)
                                                <tr>
                                                    <td>
                                                        <div class="customer-info">
                                                            <h6>{{ $transaction->customer->fullname }}</h6>
                                                            <span>{{ $transaction->customer->email }}</span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="plan_name">
                                                            <span>
                                                                {{ $transaction->plan->title }}
                                                            </span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="plan_price">
                                                            <span>
                                                                {{ $transaction->price }}
                                                            </span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="type">
                                                            <span>
                                                                {{ $transaction->recurring_type }}
                                                            </span>
                                                        </div>
                                                    </td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
            <!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
    <!-- /.content -->
@endsection

@section('extra-scripts')
  <script src="{{asset('js/apex-chart.js')}}"></script>
  {{-- <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script> --}}
  <script>
    "use strict";
        var options = {
          series: [{
          name: 'Customers',
          data: @json($chart_customers)
        }],
          chart: {
          height: 350,
          type: 'line',
        },
        forecastDataPoints: {
          count: 7
        },
        stroke: {
          width: 5,
          curve: 'smooth'
        },
      xaxis: {
          categories: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul','Aug','Sep','Oct','Nov','Dec'],
          tickAmount: 12
  },

        title: {
          text: 'Total Customers',
          align: 'left',
          style: {
            fontSize: "16px",
            color: '#666'
          }
        },
        fill: {
          type: 'gradient',
          gradient: {
            shade: 'dark',
            gradientToColors: [ '#FDD835'],
            shadeIntensity: 1,
            type: 'horizontal',
            opacityFrom: 1,
            opacityTo: 1,
            stops: [0, 100, 100, 100]
          },
        },
        yaxis: {
          min: 0,
          max: 100
        }
        };

        var chart = new ApexCharts(document.querySelector("#customer-chart"), options);
        chart.render();



        var options = {
            series: [{
            name: 'Revenues',
            data:  @json($chat_amount)
          }],
            chart: {
            height: 350,
            type: 'area'
          },
          dataLabels: {
            enabled: false
          },
          stroke: {
            curve: 'smooth'
          },
          xaxis: {
          categories: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul','Aug','Sep','Oct','Nov','Dec'],
          tickAmount: 12
  },
          title: {
          text: 'Total Revenue',
          align: 'left',
          style: {
            fontSize: "16px",
            color: '#666'
          }
        },
          tooltip: {
            x: {
              format: 'dd/MM/yy HH:mm'
            },
          },
          };

          var chart = new ApexCharts(document.querySelector("#revenue-chart"), options);
          chart.render();


  </script>
@endsection

