<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\File;

class UpdateFileSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $sourceDirectory = storage_path('app/public/uploads'); 
        $destinationDirectory = public_path('uploads'); 

        if (!File::exists($destinationDirectory)) {
            File::makeDirectory($destinationDirectory, 0755, true);
        }

        $files = File::files($sourceDirectory);

        if (empty($files)) {
            $this->command->info('No files found in the source directory.');
            return;
        }

        foreach ($files as $file) {
            $destinationPath = $destinationDirectory . '/' . $file->getFilename();
            File::copy($file->getPathname(), $destinationPath);
        }

        $this->command->info('All files have been copied from storage/app/uploads to public/uploads.');
    }
}
