<?php

namespace Database\Seeders;

use App\Models\Customer;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;

class PerviousCustomerPermission extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return void
     */

    public function run()
    {
        $previous_customers=Customer::where('type', 'customer')->get();

        foreach ($previous_customers as $customer){
            if(!$customer->hasPermissionTo('manage_developer')){
                $role = Role::updateOrCreate(['name'=>'main_customer'],['name'=>'main_customer']);
                $customer->assignRole($role);
            }
        }
    }
}
