<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddWaDeviceLimitInPlans extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('plans', function (Blueprint $table) {
            $table->integer('wa_device_limit')->default(0);
        });
        Schema::table('customer_plans', function (Blueprint $table) {
            $table->integer('wa_device_limit')->default(0);
        });
        Schema::table('message_logs', function (Blueprint $table) {
            $table->enum('send_type',['device','whatsapp'])->default('device');
            $table->string('sim_info')->nullable()->change();
        });
        Schema::table('sms_queues', function (Blueprint $table) {
            $table->enum('send_type',['device','whatsapp'])->default('device');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('plans', function (Blueprint $table) {
            $table->dropColumn('wa_device_limit');
        });
        Schema::table('customer_plans', function (Blueprint $table) {
            $table->dropColumn('wa_device_limit');
        });
        Schema::table('message_logs', function (Blueprint $table) {
            $table->dropColumn('send_type');
            $table->string('sim_info')->nullable(false)->change();
        });
        Schema::table('sms_queues', function (Blueprint $table) {
            $table->dropColumn('send_type');
        });
    }
}
