<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUssdsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ussds', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('customer_id');
            $table->string('request');
            $table->text('response')->nullable();
            $table->string('device_id');
            $table->string('device_unique_id');
            $table->string('subscriber_id');
            $table->enum('status',['pending','fetched','failed','completed'])->default('pending');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ussds');
    }
}
