<?php

namespace App\Jobs;

use App\Http\Controllers\Customer\CampaignController;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Http\Request;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use App\Models\Campaign;


class XLSXCampaignCreateJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;


    public $group_id;
    public $customer_id;
    public $campaign_id;
    public $from;
    public $body;
    public $start_date;
    public $end_date;
    public $start_time;
    public $end_time;

    public function __construct($from,$customer_id,$group_id, $campaign_id, $body,$start_date, $end_date, $start_time, $end_time)
    {
        $this->from=$from;
        $this->customer_id=$customer_id;
        $this->group_id=$group_id;
        $this->campaign_id=$campaign_id;
        $this->body=$body;
        $this->start_date = $start_date;
        $this->end_date = $end_date;
        $this->start_time = $start_time;
        $this->end_time = $end_time;

    }
    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $campaign = Campaign::where('id',$this->campaign_id)->first();
        $request_data['regenerate']=true;
        $request_data['recipient_type']='group';
        $request_data['group_id']=[$this->group_id];
        $request_data['pre_generated_from']=$this->from;
        $request_data['customer_id']=$this->customer_id;
        $request_data['campaign_id']=$this->campaign_id;
        $request_data['from_devices']=json_decode($campaign->sim_info);
        $request_data['template_body']=$this->body;
        $request_data['start_date']=$this->start_date;
        $request_data['end_date']=$this->end_date;
        $request_data['start_time']=$this->start_time;
        $request_data['end_time']=$this->end_time;

        $customRequest = Request::create(route('customer.campaign.store'), 'POST', $request_data);

        $store= new CampaignController();
        $store->store($customRequest);

    }

}
