<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class MaintenancMode
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {

        $maintence=get_settings('maintence_mode');

        if($maintence && $maintence=='enable'){
            return redirect()->route('maintenance');
        }


        return $next($request);
    }
}
