<?php

namespace App\Http\Controllers\Customer;

use App\Http\Controllers\Controller;
use App\Models\Ussd;
use Illuminate\Http\Request;

class UssdController extends Controller
{
    public function index(){
        return view('customer.ussd.index');
    }
    public function create()
    {
        $data['devices']=auth('customer')->user()->devices()->where('device_type','device')->get();
        return view('customer.ussd.create',$data);
    }
    public function store(Request $request)
    {
        $request->validate([
            'request' => 'required',
            'device_id' => 'required',
            'subscriber_id' => 'required',
        ]);

        $device=auth('customer')->user()->activeDevices($request->device_id)->first();
        if(!$device){
            return redirect()->back()->withErrors(['msg'=>'Device not found']);
        }

        $request['device_unique_id'] = $device->device_unique_id;
        auth('customer')->user()->ussds()->create($request->all());
        return back()->with('success', 'Request successfully sent');
    }

    public function getAll()
    {
        $ussd = auth('customer')->user()->ussds()->select(['id', 'request', 'device_id','response','subscriber_id','created_at']);
        return datatables()->of($ussd)
            ->addColumn('sent_at', function (Ussd $q) {
                return formatDate($q->created_at);
            })
            ->addColumn('device', function (Ussd $q) {
                if($q->device){
                    return $q->device->name ."(".$q->device->model.")";
                }

            })
            ->addColumn('sim', function (Ussd $q) {
                $sims=json_decode($q->device->sim_info);
                $name="";
                if($sims){
                    foreach($sims as $sim){
                        $sim_info=explode(':',$sim);
                        if(isset($sim_info[1]) && $sim_info[1]==$q->subscriber_id){
                            $name=$sim_info[2];
                            break;
                        }
                    }
                }

                return $name;

            })
            ->addColumn('action',function(Ussd $q){
                return '<button class="btn btn-sm btn-danger" data-message="Are you sure you want to removed this ussd. This will remove all the related responses?"
                                        data-action='.route('customer.ussd.destroy',[$q]).'
                                        data-input={"_method":"delete"}
                                        data-toggle="modal" data-target="#modal-confirm"><i class="fas fa-trash"></i></button>';
            })
            ->rawColumns(['sent_at','action'])
            ->toJson();
    }

    public function resend(Request $request){

        auth('customer')->user()->ussds()->create($request->all());

        return back()->with('success','USSD successfully resend');
    }

    public function destroy(Ussd $ussd){

        $customer_ussd = auth('customer')->user()->ussds()->where('id',$ussd->id)->first();

        if(!$customer_ussd){
            return redirect()->back()->with('fail','Invalid ussd');
        }
        $ussd->delete();

        return back()->with('success','Keyword successfully deleted');
    }
}
