<?php

namespace App\Http\Controllers\Customer;

use App\Http\Controllers\Controller;
use App\Models\Responder;
use Illuminate\Http\Request;

class ResponderController extends Controller
{
    public function index()
    {
        return view('customer.responder.index');
    }

    public function getAll()
    {

        $respond = auth('customer')->user()->responders()->select(['id', 'word', 'respond_type']);
        return datatables()->of($respond)
            ->addColumn('respond_type', function(Responder $q) {
                $type = ucfirst(str_replace('_', ' ', $q->respond_type));
                return $type;
            })
            ->addColumn('word', function(Responder $q) {

                    return "<div class='show-more' style='max-width: 500px;white-space: pre-wrap'>".$q->word."</div>";

            })
            ->addColumn('action',function(Responder $q){
                return "<a class='btn btn-sm btn-info' href='".route('customer.respond.edit', [$q->id])."'>Edit</a> &nbsp; &nbsp;".
                    '<button class="btn btn-sm btn-danger" data-message="Are you sure you want to delete this respond?"
                                        data-action='.route('customer.respond.destroy',[$q]).'
                                        data-input={"_method":"delete"}
                                        data-toggle="modal" data-target="#modal-confirm">Delete</button>' ;
            })
            ->rawColumns(['action','respond_type', 'word'])
            ->toJson();
    }

    public function create()
    {

        return view('customer.responder.create');
    }

    public function store(Request $request)
    {

        $request->validate([
            'word' => 'required',
            'respond_type' => 'required|in:case_insensitive,case_sensitive,regular_expression,contains_message',
        ]);


        $customer_numbers = auth('customer')->user()->numbers;

        auth('customer')->user()->responders()->create($request->all());

        return redirect()->route('customer.respond.index')->with('success', 'Respond successfully created');
    }
    public function edit(Responder $respond)
    {
        $data['respond'] = $respond;
        return view('customer.responder.edit',$data);
    }
    public function update(Responder $respond, Request $request)
    {

        $request->validate([
            'word' => 'required',
            'respond_type' => 'required|in:case_insensitive,case_sensitive,regular_expression,contains_message',
        ]);


        $respond->update($request->all());

        return redirect()->route('customer.respond.index')->with('success', 'Respond successfully updated');
    }
    public function destroy(Responder $respond){

        $customer_respond = auth('customer')->user()->responders()->where('id',$respond->id)->first();

        if(!$customer_respond){
            return redirect()->back()->with('fail','Invalid respond');
        }
        $respond->delete();

        return back()->with('success','Respond successfully deleted');
    }
}
