<?php

namespace App\Export;

use Illuminate\Contracts\Support\Responsable;
use Illuminate\Support\Facades\Storage;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Excel;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

class DuplicateInvalidExport implements FromCollection, Responsable,WithHeadings,WithColumnFormatting,ShouldAutoSize
{
    use Exportable;
    private $fileName;
    /**
    * Optional Writer Type
    */
    private $writerType = Excel::XLSX;
    private $file_name;

    public function __construct($fn){
        $this->fileName=$fn.".xlsx";
        $this->file_name=$fn;
    }
    public function headings(): array
    {
        return [
            'number',
        ];
    }

    public function columnFormats(): array
    {
        return [
            'A' => NumberFormat::FORMAT_NUMBER
        ];
    }

    public function collection()
    {
        $duplicates=json_decode(Storage::get("duplicates/".$this->file_name.".dp"));
        $collection=collect([]);
        foreach($duplicates as $duplicate){
            $collection->push([
                'number'=>$duplicate
            ]);
        }
        return $collection;
    }
}
